program define table1_dynan

* table of summary statistics for the paper.

  clear all
  global mydate = subinstr("${S_DATE}"," ","-",.)
  capture log close
  quietly log using logfiles/table1_dynan_$mydate, replace

  file open myfile using "logfiles/table1_dynan_$mydate.txt", write replace
  set more off

* this dataset is generated by make_bpea_data.do

  use bpea_data
  sort persid yr

* for test purposes
*  drop if _n > 10000

* create the sample variables:  

  gen insamp = 1
  local sss "Sample:  Everyone"

  gen mortyes = mort_yes_1==1 | mort_yes_2==1 if mort_yes_1~=. & mort_yes_2~=.
  

* TABLE 

  local rowlist myprev consxh_aa networth
  local rowlist `rowlist' homeown mortyes veh_loan_yes oth_dbt_yes
  local rowlist `rowlist' hsval mort_bal_amt veh_bal_amt oth_dbt
	 
  local r1  "Medians:"
  local r2  "  Income[t-1]"
  local r3  "  Non-housing consumption"
  local r4  "  Net worth"
  local r5  "Fraction holding*"
  local r6  "  Homes"
  local r7  "  Mortgage debt"
  local r8  "  Vehicle debt"
  local r9  "  Other debt"
  local r10 "Median values for those holding"
  local r11 "  Homes"
  local r12 "  Mortgage debt"
  local r13 "  Vehicle debt"
  local r14 "  Other debt"
  local r15 "Number of observations"
  
  file write myfile _column(23) "             Table 1" _n 
  file write myfile _column(23) "Summary Statistics for PSID Households" _n
  file write myfile _column(23) "   `sss'" _n _n
  /*
  file write myfile %-20s "     " ///
      _column(40) "2005" ///
      _column(50) "2007" ///
      _column(60) "2009" /// 
      _column(70) "2011" /// 
      _n _n
  */
  file write myfile %-20s "     " ///
      _column(40) "2005" ///
      _column(50) "2007" ///
      _column(60) "2009" /// 
      _n _n

  local nnn = 1
  file write myfile %-20s "`r`nnn''" _n 
  local nnn = 2
  foreach rrr in `rowlist' {
     local stat r(p50)
     local sss " "
     local fff %10.0f
     if inlist("`rrr'","homeown","mortyes","veh_loan_yes","oth_dbt_yes") {
           local stat 100*r(mean)
           local sss " "
           local fff %10.1f
           } 
     if inlist("`rrr'","hsval","mort_bal_amt","veh_bal_amt","oth_dbt") {
           local stat r(p50)
           local sss "& `rrr'>0 & `rrr'~=."
           }
     forvalues yyyy = 2005(2)2009 {
        quietly summ `rrr' [w=wgt] if yr==`yyyy' & insamp==1 `sss', detail
        scalar s`yyyy' = `stat'
     }
    
     file write myfile %-20s "`r`nnn''" ///
            _column(35) `fff' (s2005)  ///
            _column(45) `fff' (s2007)  ///
            _column(55) `fff' (s2009)  ///
            _n

            if inlist(`nnn',4,9) {
                file write myfile _n
                local nnn = `nnn' + 1
                file write myfile %-20s "`r`nnn''" _n
             }
             local nnn = `nnn'+1
      }
 
      forvalues yyyy = 2005(2)2009  {
            quietly summ wgt if yr==`yyyy' & insamp==1
            scalar num`yyyy' = r(N)
            
      }
	file write myfile _n
	file write myfile %-20s "`r`nnn''" ///
            _column(35) %10.0f (num2005)  ///
            _column(45) %10.0f (num2007)  ///
            _column(55) %10.0f (num2009)  ///
	      _n _n

   file write myfile _n
   file write myfile %-100s "* Excludes some HHs that had incomplete data on vehicle loans." _n 
   file write myfile %-100s _n "newpage" _n _n 

file close myfile

capture log close

end
